<?php defined('SYSPATH') or die('No direct script access.');

class Task_Seeder extends Minion_Task{

    private $faker;
    private $country;

    protected $_options = [
        'tables'   	=> NULL,
        'truncate' 	=> NULL,
        'sphinx'   	=> NULL,       
        'counts'	=>NULL
    ];

    /*
     * Example:
     * php index.php --task=seeder --tables=clients_events
     
     * Creare fake Clients and logpost table. Counts - parametr, created count elenent:
     * php index.php --task=seeder --tables=clients --counts=count_client
     
     
     */
    protected function _execute(array $params){
        $tables = strtolower($params['tables']);
        $truncate = strtolower($params['truncate']);
        $sphinx = strtolower($params['sphinx']);
        $counts = !empty($params['counts']) ? $params['counts'] : 10 ;
        $this->faker = Faker\Factory::create();
        $this->country = Kohana::$config->load('country')->as_array();
		
        if($tables == 'all'){
            self::luhn();
            self::clients($counts); // Defaults is All - 10
		}elseif($tables == 'clients'){
			self::clients($counts);    
        }elseif($tables != NULL){
            call_user_func([__CLASS__, $tables]);
        }

        if($truncate == 'all'){
            // TODO
        }elseif($truncate != NULL && $sphinx != NULL){
            DB::query(Database::DELETE, 'TRUNCATE RTINDEX '.$truncate)->execute(Helper::getCurrentSphinx());
        }elseif($truncate != NULL){
            DB::query(Database::DELETE, 'TRUNCATE TABLE '.$truncate.' RESTART IDENTITY;');
        }
    }

    private function luhn(){
        foreach(range(0,100) as $i) {
            $client = $this->getParamFromRandomRecord('clients', ['id', 'location']);
            $logpost_id = $this->getParamFromRandomRecord('logpost', 'id');
            $logpost_referrer = Model_Logpost::getReferer($logpost_id);

            $values = [
                $logpost_id,
                $client['id'],
                $this->faker->unixTime(),
                Task_Helper::locationToInt($client['location']),
                $this->faker->creditCardNumber,
                $logpost_referrer,
            ];

            // replace because id (logpost) must be unique
            DB::replace('luhn', ['id', 'client_id', 'datetime', 'location', 'number', 'referer'])
                ->values($values)
                ->execute(Helper::getCurrentSphinx());
        }
    }

	private function logpost($client_id_arr){
		
		$faker = Faker\Factory::create();
		/*
		 In random order from the newly created
		*/
		shuffle($client_id_arr);
		
		foreach($client_id_arr as $client_id){
			$data_logpost = '';
			$login_cl	=  htmlspecialchars(trim($faker->lastName), ENT_QUOTES, "UTF-8").rand(10, 1000);
			$Passw = '';
			$codePassArr  = array_merge( range('A', 'Z'), range('0', '9'));	
			for ($ic = 0; $ic < 5; $ic++){
				$Passw .= $codePassArr[array_rand($codePassArr)];
			}				
			$data_logpost = 'Name: '.$faker->lastName."\n";
			$data_logpost .='E-mail: '.$faker->email."\n";
			$data_logpost .='Phone: '.$faker->phoneNumber."\n";
			$data_logpost .='City: '.$faker->city."\n";
			$data_logpost .='Login: '.$login_cl."\n";		
			$data_logpost .='Password: '.$Passw."\n";	
			$data_logpost = htmlspecialchars(trim($data_logpost), ENT_QUOTES, "UTF-8");
			$post_data 		= 'user_login='.$login_cl.'&user_password='.$Passw;
			
			// Generate logpost
			for($i=0; $i<rand(1, 10); $i++){
				$referrer 		= ['https://www.yahoo.com','https://google.com ','https://www.altavista.com'];
				shuffle($referrer);	
				DB::query(Database::INSERT, "INSERT INTO logpost (client_id, data, link, referrer, post, os, os_ver) VALUES('".$client_id."', '".$data_logpost."', 'https://bofa.com', '".$referrer[0]."', '".$post_data."', 'windows', '7')")->execute();
			}
		}
	}

	private function clients($count_elements){
		
		$id=0;
		$data_logpost='';
		$test_data = '';
		$n=0;
		$client_id_arr = [];
		for ($i=0; $i < $count_elements; $i++){
			$n++;
			$ip = rand(10, 200).'.'.rand(10, 100).'.'.rand(10, 100).'.'.rand(10, 100);
			$cid1=null;
			$cid0=null;
			$elem_rand="1234567890";
			$siz=StrLen($elem_rand)-1;
			for($ig=1; $ig<=16; $ig++){
				$cid1.=$elem_rand[rand(0,$siz)];
				$cid0.=$elem_rand[rand(0,$siz)];	
			}   
			$client_add = ORM::factory('Client');
			$client_add->cid1 = $cid1;
			$client_add->cid0 = $cid0;
			$client_add->prefix = 'TEST';
			$client_add->version = 1;
			$client_add->net = '';
			$client_add->system = '';
			$client_add->ip = $ip;
			$client_add->location = 1;
			$client_add->registered = date('Y-m-d', time()-rand(300000, 500000));
			$client_add->lastactivity = date('Y-m-d', time()-rand(86000, 86000));
			$client_add->silent = TRUE;
			$client_add->create();
			$client_id_arr[] = $client_add->id;	
					
		}
		self::logpost($client_id_arr);		
		Minion_CLI::write('Success created - '.$n.' clients!');	
	}



    /* HELPERS */
    private function listIps(){
        $list = '';
        foreach(range(0, $this->faker->randomDigitNotNull) as $i){
            $list .= $this->faker->ipv4.';';
        }
        return substr($list, 0, -1);
    }

    private function randomFile(){
        exec('head -c 100000 /dev/urandom', $file);
        return pg_escape_bytea($file[0]);
    }

    private function randomBigInt($length){
        $min = -9223372036854775808;
        $max = 9223372036854775807;
        $bigint = $this->faker->regexify('[0-9]{'.$length.'}');

        if($bigint < $max && $bigint > $min){
            return $bigint;
        }

        return $this->randomBigInt($length);
    }

    private function getParamFromRandomRecord($table, $field){
        if(!is_array($field)){
            $field = [$field];
        }

        $record = DB::select_array($field)
            ->from($table)
            ->order_by(DB::expr('RANDOM()'))
            ->limit(1)
            ->execute()
            ->current();
        if(count($field) == 1){
            $record = $record[end($field)];
        }
        return $record;
    }
}